/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.server.level;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1959;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import potionstudios.byg.network.packet.ConstructBYGPlayerTrackedDataPacket;
import potionstudios.byg.network.packet.DiscoveredBiomesPacket;
import potionstudios.byg.util.ModPlatform;
import potionstudios.byg.util.codec.CodecUtil;

public record BYGPlayerTrackedData(Map<String, Set<class_5321<class_1959>>> discoveredBiomesByNameSpace) {
    public static final Codec<BYGPlayerTrackedData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.unboundedMap((Codec)Codec.STRING, CodecUtil.BIOME_SET_CODEC).fieldOf("known_biomes").forGetter(bygPlayerTrackedData -> bygPlayerTrackedData.discoveredBiomesByNameSpace)).apply((Applicative)builder, BYGPlayerTrackedData::fromCodec));

    public static BYGPlayerTrackedData fromCodec(Map<String, Set<class_5321<class_1959>>> discoveredBiomesByNameSpace) {
        return new BYGPlayerTrackedData(new HashMap<String, Set<class_5321<class_1959>>>(discoveredBiomesByNameSpace));
    }

    public void playerCreate(class_3222 player) {
        ModPlatform.INSTANCE.sendToClient(player, new ConstructBYGPlayerTrackedDataPacket(this));
    }

    public void tickPerSecond(class_3222 player) {
        class_5321 biomeResourceKey = (class_5321)player.field_6002.method_23753(player.method_24515()).method_40230().orElseThrow();
        if (this.discoveredBiomesByNameSpace.computeIfAbsent(biomeResourceKey.method_29177().method_12836(), key -> new ObjectOpenHashSet()).add(biomeResourceKey)) {
            ModPlatform.INSTANCE.sendToClient(player, new DiscoveredBiomesPacket(this.discoveredBiomesByNameSpace));
        }
    }

    public static interface Access {
        public BYGPlayerTrackedData getPlayerTrackedData();

        public BYGPlayerTrackedData setPlayerTrackedData(BYGPlayerTrackedData var1);
    }
}

